/**
 * \file: signature_db_writer.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: authorization level daemon
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2010, 2011 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#ifndef ALD_INIT_SIGNATURE_DB_WRITER_H
#define ALD_INIT_SIGNATURE_DB_WRITER_H

#include <stdio.h>
#include "ald_types.h"

error_code_t signature_db_writer_init(const char *privkey_path);

error_code_t signature_db_writer_create_db(const char *sysroot_dir, const char *db_file_path);

error_code_t signature_db_writer_add_from_file(const char *path);

void signature_db_writer_close(void);

error_code_t signature_db_writer_sign_db(const char *sysroot, const char *sig_db_path);

void signature_db_writer_deinit(void);

#endif
